/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Event;

import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.hoshino.cti.Entity.DisposibleFakePlayer;
import com.hoshino.cti.Modifier.Contributors.Mz;
import com.hoshino.cti.Modifier.Contributors.Nkssdtt;
import com.hoshino.cti.Modifier.Replace.FixedPurify;
import com.hoshino.cti.content.entityTicker.EntityTicker;
import com.hoshino.cti.content.entityTicker.EntityTickerInstance;
import com.hoshino.cti.content.entityTicker.EntityTickerManager;
import com.hoshino.cti.register.CtiBlock;
import com.hoshino.cti.register.CtiEffects;
import com.hoshino.cti.register.CtiEntityTickers;
import com.hoshino.cti.register.CtiModifiers;
import com.hoshino.cti.util.CurseUtil;
import com.hoshino.cti.util.method.GetModifierLevel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;

@Mod.EventBusSubscriber(modid="cti")
public class LivingEvents {
    @SubscribeEvent
    public static void onGobberKillEnderDragon(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)livingEntity;
            livingEntity = event.getSource().m_7639_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack skull = new ItemStack((ItemLike)Items.f_42683_);
                if (player.m_21205_().m_41720_() == TinkerTools.cleaver.get()) {
                    skull.m_41764_(9);
                    enderDragon.m_19983_(skull);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && SuperpositionHandler.hasCurio((LivingEntity)(player = (ServerPlayer)player2), (Item)EnigmaticItems.THE_CUBE)) {
            Collection harmeffect = player.m_21220_();
            for (int i = 0; i < harmeffect.size(); ++i) {
                MobEffectInstance effect = (MobEffectInstance)harmeffect.stream().toList().get(i);
                MobEffect harm = effect.m_19544_();
                if (harm.m_19483_() != MobEffectCategory.HARMFUL) continue;
                player.m_21195_(harm);
                player.m_6074_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEffectApply(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)livingEntity), (Item)EnigmaticItems.THE_CUBE)) {
                event.setResult(Event.Result.DENY);
            }
        } else if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL && EntityTickerManager.getInstance((Entity)event.getEntity()).hasTicker((EntityTicker)CtiEntityTickers.ORACLE.get())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEffectApplyHigh(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)livingEntity), (Item)EnigmaticItems.THE_CUBE)) {
                event.setResult(Event.Result.DENY);
            } else if (EntityTickerManager.getInstance((Entity)event.getEntity()).hasTicker((EntityTicker)CtiEntityTickers.ORACLE.get())) {
                Map activeEffects = event.getEntity().f_20945_;
                MobEffect effect = event.getEffectInstance().m_19544_();
                MobEffectInstance instance = (MobEffectInstance)activeEffects.get(effect);
                if (instance != null) {
                    instance.m_19558_(event.getEffectInstance());
                    event.getEntity().m_141973_(instance, true, null);
                } else {
                    activeEffects.put(effect, event.getEffectInstance());
                }
                event.getEntity().m_142540_((MobEffectInstance)activeEffects.get(effect), null);
            }
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(cap -> {
                if ((Integer)cap.get(FixedPurify.KEY_PURIFY, (Object)0) > 0) {
                    event.setResult(Event.Result.DENY);
                }
            });
        } else if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL && EntityTickerManager.getInstance((Entity)event.getEntity()).hasTicker((EntityTicker)CtiEntityTickers.ORACLE.get())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player2;
            Player player1 = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Player && player1 != (player2 = (Player)entity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFakePlayerHurt(LivingHurtEvent event) {
        FakePlayer fakePlayer;
        Entity entity;
        if (event.getEntity().m_21233_() > 10000.0f && (entity = event.getSource().m_7639_()) instanceof FakePlayer && !((fakePlayer = (FakePlayer)entity) instanceof DisposibleFakePlayer) && event.getAmount() < 2.1474836E9f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPierceHurt(LivingHurtEvent event) {
        Player player;
        MobEffectInstance instance;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (instance = (player = (Player)livingEntity).m_21124_((MobEffect)CtiEffects.stress.get())) != null && instance.m_19557_() > 0) {
            int level = instance.m_19564_() + 1;
            float red = Math.max(0.9f, 1.0f - 0.04f * (float)level);
            event.setAmount(event.getAmount() * red);
        }
        if ((livingEntity = event.getEntity()) instanceof Warden) {
            Warden warden = (Warden)livingEntity;
            if (event.getSource().m_19385_().equals("sonic_boom")) {
                event.setAmount(warden.m_21233_() / 4.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityDragonBase && event.getSource().m_7639_() != null && !(event.getSource().m_7639_() instanceof Player)) {
            event.setCanceled(true);
        }
        if (EntityTickerManager.getInstance((Entity)event.getEntity()).hasTicker((EntityTicker)CtiEntityTickers.INVULNERABLE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void glassWeakDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        if (source.m_19376_() || source.m_19379_() || source.m_238340_() || source.m_19378_() || source.m_7639_() == null) {
            return;
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        BlockPos pos1 = new BlockPos(x + 3.0, y - 1.0, z + 3.0);
        BlockPos pos2 = new BlockPos(x - 3.0, y - 1.0, z - 3.0);
        Stream stateStream = entity.f_19853_.m_45556_(new AABB(pos1, pos2));
        List list = stateStream.toList();
        int count = 0;
        for (BlockState state : list) {
            if (state.m_60734_() != CtiBlock.aluminium_glass.get()) continue;
            ++count;
        }
        event.setAmount(event.getAmount() * 1.0f - Math.min(40.0f, (float)count) / 100.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCurseDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SuperpositionHandler.isTheCursedOne((Player)player)) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        int fre = CurseUtil.getDeathFrequency(player);
        CurseUtil.setDeathFrequency(player, fre + 1);
        CurseUtil.setResoluteTime(player, 0);
        if (fre < 3) {
            return;
        }
        CurseUtil.setPunishTime(player, 1);
        CurseUtil.setDeathFrequency(player, fre + 1);
    }

    @SubscribeEvent
    public static void deathTimePunish(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SuperpositionHandler.isTheCursedOne((Player)player)) {
            return;
        }
        int fre = CurseUtil.getDeathFrequency(player);
        int time = CurseUtil.getPunishTime(player);
        if (time == 0) {
            return;
        }
        event.setAmount((Math.max((float)(fre - 3) * 0.5f, 0.0f) + 1.0f) * event.getAmount());
    }

    @SubscribeEvent
    public static void punishWeakenPlayer(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!SuperpositionHandler.isTheCursedOne((Player)player)) {
            return;
        }
        int fre = CurseUtil.getDeathFrequency(player);
        int time = CurseUtil.getPunishTime(player);
        if (time == 0) {
            return;
        }
        event.setAmount(event.getAmount() / (float)Math.max(fre - 3, 0));
    }

    @SubscribeEvent
    public static void resoluteModify(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SuperpositionHandler.isTheCursedOne((Player)player)) {
            return;
        }
        int time = CurseUtil.getResoluteTime(player);
        if (time == 0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f - 0.06f * (float)time));
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity living = event.getEntity();
        EntityTickerManager.EntityTickerManagerInstance tickerManager = EntityTickerManager.getInstance((Entity)living);
        EntityTickerInstance tickerInstance = tickerManager.getTicker((EntityTicker)CtiEntityTickers.SACRIFICE_SEAL.get());
        if (tickerInstance != null) {
            float maxHealth = living.m_21233_() * (1.0f - 0.1f * (float)tickerInstance.level);
            if (living.m_21223_() + event.getAmount() > maxHealth) {
                living.m_21153_(maxHealth);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void NKSSreloadTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        int reload = entity.getPersistentData().m_128451_("nksszs_reload");
        if (reload > 0) {
            entity.getPersistentData().m_128405_("nksszs_reload", reload - 1);
        }
    }

    @SubscribeEvent
    public static void NKSSKillReload(LivingDeathEvent event) {
        Entity killer;
        LivingEntity entity = event.getEntity();
        int reload = entity.getPersistentData().m_128451_("nksszs_reload");
        if (reload > 0 && (killer = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)killer;
            ToolStack view = ToolStack.from((ItemStack)player.m_21205_());
            view.getPersistentData().remove(Nkssdtt.NKSSTK_COOLDOWN);
            MobEffectInstance effect = player.m_21124_((MobEffect)CtiEffects.blood_angry.get());
            if (effect != null) {
                int level = effect.m_19564_();
                player.m_7292_(new MobEffectInstance((MobEffect)CtiEffects.blood_angry.get(), 1200, Math.min(level + 1, 4)));
            } else {
                player.m_7292_(new MobEffectInstance((MobEffect)CtiEffects.blood_angry.get(), 1200, 0));
            }
        }
    }

    @SubscribeEvent
    public static void NKSSExtraDamage(LivingDamageEvent event) {
        MobEffectInstance effect;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_21023_((MobEffect)CtiEffects.blood_angry.get()) && (effect = player.m_21124_((MobEffect)CtiEffects.blood_angry.get())) != null) {
            int level = effect.m_19564_();
            event.setAmount(event.getAmount() * (1.0f + (float)level * 0.2f));
        }
    }

    @SubscribeEvent
    public static void cancelFallDamage(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (event.getSource().m_146707_() && (livingEntity = event.getEntity()) instanceof Player && GetModifierLevel.HandsHaveModifierlevel((LivingEntity)(player = (Player)livingEntity), CtiModifiers.NKSSZS_STATIC_MODIFIER.getId())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void miziPreventDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = player.m_21205_();
        ToolStack view = ToolStack.from((ItemStack)itemStack);
        ToolStack view2 = ToolStack.from((ItemStack)player.m_21206_());
        int currentMizi = view.getPersistentData().getInt(Mz.CurrentMZ);
        int currentMizi2 = view2.getPersistentData().getInt(Mz.CurrentMZ);
        if (currentMizi > 0) {
            LivingEvents.prevent(event, player, (IToolStackView)view, currentMizi);
            return;
        }
        if (currentMizi2 > 0) {
            LivingEvents.prevent(event, player, (IToolStackView)view2, currentMizi2);
        }
    }

    @SubscribeEvent
    public static void thousandBless(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = player.m_21205_();
        if (ModifierUtil.getModifierLevel((ItemStack)itemStack, (ModifierId)CtiModifiers.THOUSAND_STAR_BLESS_STATIC_MODIFIER.getId()) > 0) {
            long count = ModifierManager.INSTANCE.getAllValues().count();
            event.setAmount(event.getAmount() * (float)count);
        }
    }

    private static void prevent(LivingDeathEvent event, Player player, IToolStackView view, int currentAmount) {
        event.setCanceled(true);
        player.m_21153_(player.m_21233_());
        player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12513_, SoundSource.AMBIENT, 1.0f, 1.0f);
        view.getPersistentData().putInt(Mz.CurrentMZ, currentAmount - 1);
    }

    @SubscribeEvent
    public static void miziModifyDamage(LivingHurtEvent event) {
    }
}

